<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';

if (current_user()) { header("Location: /home.php"); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim($_POST['email'] ?? '');
  $pass = $_POST['password'] ?? '';

  if ($email && $pass) {
    $db = db();
    $stmt = $db->prepare("SELECT id,email,password_hash,display_name,role_code FROM users WHERE email=? LIMIT 1");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $u = $stmt->get_result()->fetch_assoc();

    if ($u && password_verify($pass, $u['password_hash'])) {
      $_SESSION['user'] = [
        'id' => (int)$u['id'],
        'email' => $u['email'],
        'display_name' => $u['display_name'],
        'role_code' => $u['role_code'],
      ];
      unset($_SESSION['perms']);
      header("Location: /home.php"); exit;
    } else {
      $error = 'E-posta veya şifre hatalı.';
    }
  } else $error = 'E-posta ve şifre girin.';
}

$pageTitle = "Giriş";
$viewFile = __DIR__ . '/../app/views/login_view.php';
include __DIR__ . '/../app/layouts/layout.php';

