<?php
// public/api/navbar_actions.php
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/db.php';

require_login();
if (!can_manage_settings()) {
  http_response_code(403);
  echo json_encode(['ok'=>false,'msg'=>'Yetkiniz yok.']); exit;
}

$db = db();
$action = $_GET['action'] ?? '';

function out($arr){ echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }

try {
  if ($action === 'get') {
    $id = (int)($_GET['id'] ?? 0);
    $stmt = $db->prepare("SELECT * FROM nav_items WHERE id=? AND deleted_at IS NULL LIMIT 1");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $it = $stmt->get_result()->fetch_assoc();
    if (!$it) out(['ok'=>false,'msg'=>'Kayıt bulunamadı.']);
    out(['ok'=>true,'item'=>$it]);
  }

  $raw = file_get_contents('php://input');
  $data = json_decode($raw, true);
  if (!is_array($data)) $data = [];

  if ($action === 'save') {
    $id = (int)($data['id'] ?? 0);
    $parent_id = $data['parent_id'] ?? null;
    $title = trim((string)($data['title'] ?? ''));
    $key = trim((string)($data['key'] ?? ''));
    $icon = trim((string)($data['icon'] ?? ''));
    $type = ($data['type'] ?? 'link') === 'dropdown' ? 'dropdown' : 'link';
    $url = trim((string)($data['url'] ?? ''));
    $sort = (int)($data['sort_order'] ?? 100);
    $is_active = (int)($data['is_active'] ?? 1) ? 1 : 0;
    $role_code = trim((string)($data['role_code'] ?? '')) ?: null;
    $perm_code = trim((string)($data['permission_code'] ?? '')) ?: null;

    if ($title === '' || $key === '') out(['ok'=>false,'msg'=>'Başlık ve Key zorunlu.']);
    if ($type === 'link' && $url === '') out(['ok'=>false,'msg'=>'Link tipinde URL zorunlu.']);
    if ($type === 'dropdown') $url = null;

    if ($id > 0) {
      $stmt = $db->prepare("UPDATE nav_items SET `key`=?, title=?, icon=?, `type`=?, url=?, sort_order=?, is_active=?, parent_id=?, role_code=?, permission_code=? WHERE id=? AND deleted_at IS NULL");
      $stmt->bind_param("sssssiiisssi", $key, $title, $icon, $type, $url, $sort, $is_active, $parent_id, $role_code, $perm_code, $id);
      $stmt->execute();
      out(['ok'=>true,'id'=>$id]);
    } else {
      $stmt = $db->prepare("INSERT INTO nav_items (`key`, title, icon, `type`, url, sort_order, is_active, parent_id, role_code, permission_code) VALUES (?,?,?,?,?,?,?,?,?,?)");
      $stmt->bind_param("sssssiiiss", $key, $title, $icon, $type, $url, $sort, $is_active, $parent_id, $role_code, $perm_code);
      $stmt->execute();
      out(['ok'=>true,'id'=>$db->insert_id]);
    }
  }

  if ($action === 'copy') {
    $id = (int)($data['id'] ?? 0);
    if ($id<=0) out(['ok'=>false,'msg'=>'Geçersiz id.']);

    $stmt = $db->prepare("SELECT * FROM nav_items WHERE id=? AND deleted_at IS NULL LIMIT 1");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $it = $stmt->get_result()->fetch_assoc();
    if (!$it) out(['ok'=>false,'msg'=>'Kayıt bulunamadı.']);

    // generate new key
    $baseKey = $it['key'] . '_copy';
    $newKey = $baseKey;
    $n = 1;
    while(true){
      $chk = $db->prepare("SELECT 1 FROM nav_items WHERE `key`=? AND parent_id <=> ? AND deleted_at IS NULL LIMIT 1");
      $pid = $it['parent_id'];
      $chk->bind_param("si", $newKey, $pid);
      $chk->execute();
      $exists = $chk->get_result()->fetch_row();
      if (!$exists) break;
      $n++;
      $newKey = $baseKey . '_' . $n;
    }

    // insert copy
    $stmt2 = $db->prepare("INSERT INTO nav_items (`key`, title, icon, `type`, url, sort_order, is_active, parent_id, role_code, permission_code) VALUES (?,?,?,?,?,?,?,?,?,?)");
    $sort = ((int)$it['sort_order']) + 5;
    $stmt2->bind_param("sssssiiiss",
      $newKey, $it['title'], $it['icon'], $it['type'], $it['url'],
      $sort, $it['is_active'], $it['parent_id'], $it['role_code'], $it['permission_code']
    );
    $stmt2->execute();
    $newId = $db->insert_id;

    // if dropdown root, copy children too
    if ($it['type'] === 'dropdown') {
      $stmtc = $db->prepare("SELECT * FROM nav_items WHERE parent_id=? AND deleted_at IS NULL ORDER BY sort_order ASC, id ASC");
      $stmtc->bind_param("i", $id);
      $stmtc->execute();
      $rc = $stmtc->get_result();
      while($ch = $rc->fetch_assoc()){
        $childKey = $ch['key'].'_copy';
        $childNewKey = $childKey;
        $k=1;
        while(true){
          $chk = $db->prepare("SELECT 1 FROM nav_items WHERE `key`=? AND parent_id=? AND deleted_at IS NULL LIMIT 1");
          $chk->bind_param("si", $childNewKey, $newId);
          $chk->execute();
          $exists = $chk->get_result()->fetch_row();
          if (!$exists) break;
          $k++;
          $childNewKey = $childKey . '_' . $k;
        }

        $ins = $db->prepare("INSERT INTO nav_items (`key`, title, icon, `type`, url, sort_order, is_active, parent_id, role_code, permission_code) VALUES (?,?,?,?,?,?,?,?,?,?)");
        $ins->bind_param("sssssiiiss",
          $childNewKey, $ch['title'], $ch['icon'], $ch['type'], $ch['url'],
          $ch['sort_order'], $ch['is_active'], $newId, $ch['role_code'], $ch['permission_code']
        );
        $ins->execute();
      }
    }

    out(['ok'=>true,'id'=>$newId]);
  }

  if ($action === 'delete') {
    $id = (int)($data['id'] ?? 0);
    if ($id<=0) out(['ok'=>false,'msg'=>'Geçersiz id.']);
    $stmt = $db->prepare("UPDATE nav_items SET is_active=0, deleted_at=NOW() WHERE id=? AND deleted_at IS NULL");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    out(['ok'=>true]);
  }

  if ($action === 'reorder_roots') {
    $ids = $data['ids'] ?? [];
    if (!is_array($ids) || count($ids)===0) out(['ok'=>false,'msg'=>'ids boş.']);

    $db->begin_transaction();
    $order = 10;
    $stmt = $db->prepare("UPDATE nav_items SET sort_order=? WHERE id=? AND parent_id IS NULL AND deleted_at IS NULL");
    foreach($ids as $id){
      $id = (int)$id;
      $stmt->bind_param("ii", $order, $id);
      $stmt->execute();
      $order += 10;
    }
    $db->commit();
    out(['ok'=>true]);
  }

  out(['ok'=>false,'msg'=>'Geçersiz action']);
} catch (Throwable $e) {
  http_response_code(500);
  out(['ok'=>false,'msg'=>$e->getMessage()]);
}

