<?php
// includes/navbar_loader.php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';

function nav_item_allowed(array $item): bool {
  if (empty($item['is_active'])) return false;
  if (!empty($item['deleted_at'])) return false;

  $role = $item['role_code'] ?? null;
  $perm = $item['permission_code'] ?? null;

  if ($role && !has_role($role)) return false;
  if ($perm && !has_perm($perm)) return false;

  return true;
}

function load_nav_tree(): array {
  $db = db();
  $root = [];
  $res = $db->query("SELECT * FROM nav_items WHERE parent_id IS NULL ORDER BY sort_order ASC, id ASC");
  while($row = $res->fetch_assoc()){
    if (!nav_item_allowed($row)) continue;
    $row['children'] = [];
    if ($row['type'] === 'dropdown') {
      $stmt = $db->prepare("SELECT * FROM nav_items WHERE parent_id=? ORDER BY sort_order ASC, id ASC");
      $stmt->bind_param("i", $row['id']);
      $stmt->execute();
      $r2 = $stmt->get_result();
      while($ch = $r2->fetch_assoc()){
        if (!nav_item_allowed($ch)) continue;
        $row['children'][] = $ch;
      }
    }
    $root[] = $row;
  }
  return $root;
}

function build_bottom_nav(array $items, string $activeKey = ''): array {
  // max 5 visible. if more than 5: show first 4 + "more" dropdown with rest
  if (count($items) <= 5) return $items;

  $first = array_slice($items, 0, 4);
  $rest = array_slice($items, 4);

  $more = [
    'id' => 0,
    'key' => 'more',
    'title' => 'Diğer',
    'icon' => 'bi-three-dots',
    'type' => 'dropdown',
    'url' => null,
    'children' => array_map(function($it){
      // ensure dropdown items still work; for dropdown roots, show their children nested as headings in UI is optional
      return $it;
    }, $rest),
  ];
  $first[] = $more;
  return $first;
}

