<?php
// includes/auth.php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__ . '/db.php';

function current_user(): ?array {
  return $_SESSION['user'] ?? null;
}

function require_login(): void {
  if (!current_user()) {
    header("Location: /login.php");
    exit;
  }
}

function has_role(string $role): bool {
  $u = current_user();
  return $u && ($u['role_code'] ?? '') === $role;
}

function user_permissions(): array {
  $u = current_user();
  if (!$u) return [];
  if (isset($_SESSION['perms']) && is_array($_SESSION['perms'])) return $_SESSION['perms'];

  $db = db();
  $stmt = $db->prepare("SELECT perm_code FROM user_permissions WHERE user_id=?");
  $stmt->bind_param("i", $u['id']);
  $stmt->execute();
  $res = $stmt->get_result();
  $perms = [];
  while($row = $res->fetch_assoc()){
    $perms[$row['perm_code']] = true;
  }
  $_SESSION['perms'] = $perms;
  return $perms;
}

function has_perm(string $perm): bool {
  $perms = user_permissions();
  return !empty($perms[$perm]);
}

function can_manage_settings(): bool {
  return has_perm('settings.manage') || has_role('admin');
}

